 /******************************************************************************
 *
 *	   MIKADO LEVEL    M A I N   P R O G R A M 
 *
 *	   Jan 2012 - Geoff Champion - Base s/w - Silicon Chip Inclinometer and G Force Meter
 *
 *     April 2020 - Upgraded to XC8 compiler
 *
 */
// PIC18LF14K22 Configuration Bit Settings

// 'C' source line config statements

// CONFIG1H
#pragma config FOSC = IRC       // Oscillator Selection bits (Internal RC oscillator)
#pragma config PLLEN = OFF      // 4 X PLL Enable bit (PLL is under software control)
#pragma config PCLKEN = OFF     // Primary Clock Enable bit (Primary clock is under software control)
#pragma config FCMEN = OFF      // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor disabled)
#pragma config IESO = OFF       // Internal/External Oscillator Switchover bit (Oscillator Switchover mode disabled)

// CONFIG2L
#pragma config PWRTEN = OFF     // Power-up Timer Enable bit (PWRT disabled)
#pragma config BOREN = SBORDIS  // Brown-out Reset Enable bits (Brown-out Reset enabled in hardware only (SBOREN is disabled))
#pragma config BORV = 19        // Brown Out Reset Voltage bits (VBOR set to 1.9 V nominal)

// CONFIG2H
#pragma config WDTEN = OFF      // Watchdog Timer Enable bit (WDT is controlled by SWDTEN bit of the WDTCON register)
#pragma config WDTPS = 32768    // Watchdog Timer Postscale Select bits (1:32768)

// CONFIG3H
#pragma config HFOFST = OFF     // HFINTOSC Fast Start-up bit (The system clock is held off until the HFINTOSC is stable.)
#pragma config MCLRE = ON       // MCLR Pin Enable bit (MCLR pin enabled, RA3 input pin disabled)

// CONFIG4L
#pragma config STVREN = ON      // Stack Full/Underflow Reset Enable bit (Stack full/underflow will cause Reset)
#pragma config LVP = OFF        // Single-Supply ICSP Enable bit (Single-Supply ICSP disabled)
#pragma config BBSIZ = OFF      // Boot Block Size Select bit (1kW boot block size)
#pragma config XINST = OFF      // Extended Instruction Set Enable bit (Instruction set extension and Indexed Addressing mode disabled (Legacy mode))

// CONFIG5L
#pragma config CP0 = OFF        // Code Protection bit (Block 0 not code-protected)
#pragma config CP1 = OFF        // Code Protection bit (Block 1 not code-protected)

// CONFIG5H
#pragma config CPB = OFF        // Boot Block Code Protection bit (Boot block not code-protected)
#pragma config CPD = OFF        // Data EEPROM Code Protection bit (Data EEPROM not code-protected)

// CONFIG6L
#pragma config WRT0 = OFF       // Write Protection bit (Block 0 not write-protected)
#pragma config WRT1 = OFF       // Write Protection bit (Block 1 not write-protected)

// CONFIG6H
#pragma config WRTC = OFF       // Configuration Register Write Protection bit (Configuration registers not write-protected)
#pragma config WRTB = OFF       // Boot Block Write Protection bit (Boot block not write-protected)
#pragma config WRTD = OFF       // Data EEPROM Write Protection bit (Data EEPROM not write-protected)

// CONFIG7L
#pragma config EBTR0 = OFF      // Table Read Protection bit (Block 0 not protected from table reads executed in other blocks)
#pragma config EBTR1 = OFF      // Table Read Protection bit (Block 1 not protected from table reads executed in other blocks)

// CONFIG7H
#pragma config EBTRB = OFF      // Boot Block Table Read Protection bit (Boot block not protected from table reads executed in other blocks)

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

#include <xc.h>

#include "accel.h"
#include "display.h"

#define MAX_ADDRESS        0x0C
extern uchar max_angle;
long cnt;

//#####################################################################################

void main(void)
{
	// Configure System
	OSCCONbits.IDLEN = 0;					// SLEEP instruction enters sleep
	OSCCONbits.IRCF = 7;					// 16 MHz Clock
	OSCCONbits.SCS = 2;						// Primary clock only
	ANSEL = 0b00000000;                     // No analogue inputs
	RCONbits.IPEN = 1;						// Two-level interrupt priority
	INTCONbits.GIEH = 1;					// Enable hi-priority ints
	INTCONbits.GIEL = 1;					// Enable lo-priority interrupts
	
	// Initialise display
    dispInitialise();

    // Set up I2C
    i2cInitialise();

	// Display Max angle
	max_angle = (unsigned int) eeReadFloat(MAX_ADDRESS);
	dispMax(max_angle);
	
	// Delay
	cnt = 0x50000;
	while(cnt > 0) --cnt;

	max_angle = 0;
	eeWriteFloat(MAX_ADDRESS, 0);

    // Set up pins
    CAL_TRIS = 1;
    INT1_TRIS = 1;
    INT2_TRIS = 1;
    INTCON2bits.INTEDG1 = 0;                // Int 1 falling edge
    INTCON3bits.INT1IP = 0;                 // Int 1 low prio
    INTCON2bits.INTEDG2 = 0;                // Int 2 falling edge
    INTCON3bits.INT2IP = 0;                 // Int 2 low prio
    CAL_PULLUP = 1;
    INTCON2bits.RABPU = 0;                  // enable pullups
    INTCON2bits.RABIP = 0;                  // Cal button low priority
    CAL_IOC = 1;                            // Enable interrupt on change
    i2cSetByte(ACC_ADDR, CTRL_REG1, i2cGetByte(ACC_ADDR, CTRL_REG1) & 0xfe);

    // Set Up Timer 0
    T0CONbits.TMR0ON = 0;                   // Off
    T0CONbits.T08BIT = 0;                   // 16 bit
    T0CONbits.T0CS = 0;                     // Internal 4MHz clock
    T0CONbits.PSA = 0;                      // Prescaler assigned
    T0CONbits.T0PS = 7;                     // Divide by 256
    INTCON2bits.TMR0IP = 0;                 // low prioity interrupt

	// Initialise Accelerometer
    accInitialise();

	accStart();
	
	while(1);	
}
					
//#####################################################################################

//     Interrupt service routine - low

//#####################################################################################

void interrupt low_priority low_isr (void)
{
/* service routine body goes here */
	if(INTCON3bits.INT1IF == 1){  	// accelerometer INT1
		INTCON3bits.INT1IF = 0;
		accInt1isr();
	}
	else if(INTCONbits.RABIF == 1){		// accelerometer Cal Button
		INTCONbits.RABIF = 0;
		accCalisr();
	}
	else if(INTCONbits.TMR0IF == 1) {   // Cal Button Timeout
		INTCONbits.TMR0IF = 0;
		accTimeout();
	}	
}

//#####################################################################################

//     Interrupt service routine - high

//#####################################################################################

void interrupt high_priority high_isr (void)
{
/* service routine body goes here */
	if(PIR1bits.TMR1IF == 1){		// Timer 1 interrupt
		PIR1bits.TMR1IF = 0;	
		dispMux();	
	}
	if(PIR1bits.SSPIF == 1){		// I2C interrupt
		PIR1bits.SSPIF = 0;	
		i2cStateMachine();
	}		
}
